%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%    GUI for the dielectric-strength table of materials


function varargout = DieStrength(varargin)
% DIESTRENGTH M-file for DieStrength.fig
%      DIESTRENGTH, by itself, creates a new DIESTRENGTH or raises the existing
%      singleton*.
%
%      H = DIESTRENGTH returns the handle to a new DIESTRENGTH or the handle to
%      the existing singleton*.
%
%      DIESTRENGTH('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in DIESTRENGTH.M with the given input arguments.
%
%      DIESTRENGTH('Property','Value',...) creates a new DIESTRENGTH or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before DieStrength_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to DieStrength_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help DieStrength

% Last Modified by GUIDE v2.5 30-May-2010 16:49:28

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @DieStrength_OpeningFcn, ...
                   'gui_OutputFcn',  @DieStrength_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before DieStrength is made visible.
function DieStrength_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to DieStrength (see VARARGIN)
% Import the adequate dielectric strength
handles.blank = '';
handles.Air = '3';
handles.Alumina = '~35';
handles.Bakelite = '25';
handles.Barium = '7.5';
handles.Freon = '~8';
handles.FusedQuartz = '~1000';
handles.GalliumArsenide = '~40';
handles.Germanium = '~10';
handles.Glass = '30';
handles.Mica = '200';
handles.Oil = '15';
handles.Paper = '15';
handles.Paraffin = '~30';
handles.Polyethylene = '47';
handles.Polystyrene = '20';
handles.Porcelain = '11';
handles.Rubber = '25';
handles.Silicon = '~30';
handles.Nitride = '~1000';
handles.Teflon = '20';
handles.Vacuum = 'inf';
handles.Wood = '~10';


% Choose default command line output for DieStrength
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

set(0,'units','inches');
screenSize = get(0,'ScreenSize');
set(hObject,'Units','inches','Position',[screenSize(3)/2-(3.9479/2),screenSize(4)/2-(1.8229/2),3.9479,1.8229]);

% UIWAIT makes DieStrength wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = DieStrength_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on selection change in popupmenu1.
function popupmenu1_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Determine the selected data set.

% Set current data to the selected data set.
switch get(handles.popupmenu1,'Value')
case 1
    handles.current_data = handles.blank;
    set(handles.text3,'String',handles.current_data);
case 2 %'Air'
   handles.current_data = handles.Air;
   set(handles.text3,'String',handles.current_data);
case 3 %'Alumina' 
   handles.current_data = handles.Alumina;
   set(handles.text3,'String',handles.current_data);
case 4 %'Bakelite'
   handles.current_data = handles.Bakelite;
   set(handles.text3,'String',handles.current_data);
case 5 %'Barium titanate'
   handles.current_data = handles.Barium;
   set(handles.text3,'String',handles.current_data);
case 6 %'Freon'
   handles.current_data = handles.Freon;
   set(handles.text3,'String',handles.current_data);
case 7 %'Fused quartz'
   handles.current_data = handles.FusedQuartz;
   set(handles.text3,'String',handles.current_data);
case 8 %'Gallium arsenide'
   handles.current_data = handles.GalliumArsenide;
   set(handles.text3,'String',handles.current_data);
case 9 %'Germanium'
   handles.current_data = handles.Germanium;
   set(handles.text3,'String',handles.current_data);
case 10 %'Glass (plate)'
   handles.current_data = handles.Glass;
   set(handles.text3,'String',handles.current_data);
case 11 %'Mica'
   handles.current_data = handles.Mica;
   set(handles.text3,'String',handles.current_data);
case 12 %'Oil (mineral)'
   handles.current_data = handles.Oil;
   set(handles.text3,'String',handles.current_data);
case 13 %'Paper (impregnated)'
   handles.current_data = handles.Paper;
   set(handles.text3,'String',handles.current_data);
case 14 %'Paraffin'
   handles.current_data = handles.Paraffin;
   set(handles.text3,'String',handles.current_data);
case 15 %'Polyethylene'
   handles.current_data = handles.Polyethylene;
   set(handles.text3,'String',handles.current_data);
case 16 %'Polystyrene'
   handles.current_data = handles.Polystyrene;
   set(handles.text3,'String',handles.current_data);
case 17 %'Porcelain'
   handles.current_data = handles.Porcelain;
   set(handles.text3,'String',handles.current_data);
case 18 %'Rubber (hard)'
   handles.current_data = handles.Rubber;
   set(handles.text3,'String',handles.current_data);
case 19 %'Silicon'
   handles.current_data = handles.Silicon;
   set(handles.text3,'String',handles.current_data);
case 20 %'Silicon nitride'
   handles.current_data = handles.Nitride;
   set(handles.text3,'String',handles.current_data);
case 21 %'Teflon'
   handles.current_data = handles.Teflon;
   set(handles.text3,'String',handles.current_data);
case 22 %'Vacuum'
   handles.current_data = handles.Vacuum;
   set(handles.text3,'String',handles.current_data);
case 23 %'Wood (douglas fir)'
   handles.current_data = handles.Wood;
   set(handles.text3,'String',handles.current_data);
        
end
% Save the handles structure.
guidata(hObject,handles)


% Hints: contents = get(hObject,'String') returns popupmenu1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu1


% --- Executes during object creation, after setting all properties.
function popupmenu1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
